float4x4	viewProj;

struct VSINPUT
{
	float3 position : POSITION;
	float4 colour		: COLOR0;
};

struct VSOUTPUT
{
	float4 position	: POSITION;
	float4 colour		: COLOR0;
};

VSOUTPUT VShader( VSINPUT _input )
{
	VSOUTPUT _output;

	// Transform position
	_output.position = mul( float4( _input.position, 1.0f ), viewProj );

	// Pass through colour
	_output.colour = _input.colour;

	return _output;
}

VSOUTPUT VShader2D( VSINPUT _input )
{
	VSOUTPUT _output;
	
	_output.position = float4( _input.position, 1.0f );
	
	_output.colour = _input.colour;
	
	return _output;
}

struct PSOUTPUT
{
	float4 colour : COLOR0;
};

PSOUTPUT FragmentShader( VSOUTPUT _input )
{
	PSOUTPUT _output;

	_output.colour = _input.colour;

	return _output;
}

technique DebugLines
<
	bool supportsSpecialisedLighting = false;
	bool preservesGlobalState = false;
	string normalBehaviour			= "ERMB_RENDER";
	string normalTechnique			= "DebugLines";
	int    normalDeferredID			= 0;
>
{
	pass Pass0
	{
		ZEnable = 1;
		ZWriteEnable = true;
		AlphaBlendEnable = false;
		cullfaceenable=false;
#if defined (_PS3_)		
		VertexShader = compile sce_vp_rsx VShader();
		PixelShader = compile sce_fp_rsx FragmentShader();
#endif		
	}
}

technique DebugLines_Trans
<
	bool preservesGlobalState = false;
	string normalBehaviour			= "ERMB_RENDER";
	string normalTechnique			= "DebugLines_Trans";
	int    normalDeferredID			= 2;
>
{
	pass Pass0
	{
		ZEnable = 1;
		ZWriteEnable = true;
		AlphaBlendEnable = true;
		blendfunc=int2(SrcAlpha, OneMinusSrcAlpha);
		cullfaceenable=false;
#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx VShader();
		PixelShader = compile sce_fp_rsx FragmentShader();
#endif		
	}
}

technique DebugLines2D
<
	bool preservesGlobalState = false;
	string normalBehaviour			= "ERMB_RENDER";
	string normalTechnique			= "DebugLines2D";
	int    normalDeferredID			= 0;
>
{
	pass Pass0
	{
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = false;
		cullfaceenable=false;
#if defined (_PS3_)		
		VertexShader = compile sce_vp_rsx VShader2D();
		PixelShader = compile sce_fp_rsx FragmentShader();
#endif		
	}
}

technique DebugLines2D_Trans
<
	bool preservesGlobalState = false;
	string normalBehaviour			= "ERMB_RENDER";
	string normalTechnique			= "DebugLines2D_Trans";
	int    normalDeferredID			= 0;
>
{
	pass Pass0
	{
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		blendfunc=int2(SrcAlpha, OneMinusSrcAlpha);
		cullfaceenable=false;
#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx VShader2D();
		PixelShader = compile sce_fp_rsx FragmentShader();
#endif		
	}
}
